%%
% Post-Processing PLot file for Series HEV 
Time = Vehicle_Speed_mph_str.time;
Vehicle_Speed_mph = Vehicle_Speed_mph_str.signals.values;
%%

figure(1)
xtitle=sprintf('Drive Cycle: %s\nVehicle Speed',strrep(fn,'_',' '));
subplot(6,1,1);
plot(Time,Vehicle_Speed_mph,'r-',Time, Desired_Vehicle_Speed,'b-');
legend('Vehicle Speed (mph)', 'Desired Vehicle Speed (mph)');
title(xtitle);
axis([min(Time),max(Time),0,60]);
grid on
%%


subplot(6,1,2);
plot(Time,Battery_Voltage_V);
axis([min(Time),max(Time),200,450]);
title('Battery Voltage (V)');
grid on

%%

subplot(6,1,3);
plot(Time,Battery_SOC);
title('Battery State of Charge');
axis([min(Time),max(Time),0.5,0.8]);
grid on
%%


subplot(6,1,4);
plot(Time,Generator_Current_A);
title('Generator Current (A)');
axis([min(Time),max(Time),-20,60]);
grid on
%%

subplot(6,1,5);
plot(Time,Throttle_Request);
title('Engine Throttle Request');
axis([min(Time),max(Time),0,1]);
grid on
%%


subplot(6,1,6);
plot(Time,Measured_Engine_rpm);
title('Engine Speed (rpm)');
axis([min(Time),max(Time),0,2000]);
grid on